function VAR=study_variability(Resume, EXT)

% It analyzes the changes of mouvement along every trajectory

% INPUT
%  Resume  : nb tracks | original track | class of mvnt | Ext | Stat_msd

% OUTPUT
%  VAR :   original analyzed track | % conf | % dir | % brow | % imm | nb
%  of changes | duration in terms of subtracks | probability of change |
%  Extent

tracksorig = sort(unique(Resume(:,2)));
N=numel(tracksorig);
trackscourt=[];
VAR=zeros(N,9);
for i=1:N
   VAR(i,1)=tracksorig(i);
    
  ind=find(Resume(:,2)==tracksorig(i));
  
  if isempty(ind)==0
  % Percentage of each movement
  for j=1:4
  J=find(Resume(ind,3)==j); 
  VAR(i,j+1)=numel(Resume(J,2))/numel(ind);
  end
  
  % Number of changes of movement
  count=0;
  for k=1:numel(ind)-1
     if Resume(ind(k),3) ~=  Resume(ind(k+1),3)
         count=count+1;
     end
  end
   VAR(i,6)=count;
   VAR(i,7)=numel(ind);
   % Extent of track
   indext=find(EXT(2,:)==tracksorig(i));
   VAR(i,9)=EXT(1,indext);
%   else
%       trackscourt=[trackscourt;tracksorig(i)];
  end
end
% VAR(trackscourt,:)=[];
% probability of change
VAR(:,8)=VAR(:,6)./VAR(:,7);

end